/* dropDownArrow.js
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

/* exported DropDownArrow */

const { GLib } = imports.gi;

const Main = imports.ui.main;

const KEY_SHOW_DROPDOWN_ARROW = 'show-dropdown-arrow';

class DropDownArrow {
    constructor(settings) {
        this._settings = settings;
        this._settingsChangedId = this._settings.connect('changed::%s'.format(KEY_SHOW_DROPDOWN_ARROW), this._onChangedShowDropDownArrow.bind(this));
        this._extensionStateChangedID = Main.extensionManager.connect('extension-state-changed', this._onChangedShowDropDownArrow.bind(this));
        GLib.timeout_add(GLib.PRIORITY_DEFAULT, 200, () => {
            this._onChangedShowDropDownArrow();
            return GLib.SOURCE_REMOVE;
        });
    }

    _onChangedShowDropDownArrow() {
        let showDropDownArrow = this._settings.get_boolean(KEY_SHOW_DROPDOWN_ARROW);
        this._updateVisibility(showDropDownArrow, null);
    }

    _updateVisibility(visible, child) {
        if (!child) child = Main.panel;
        if (child.has_style_class_name && child.has_style_class_name('popup-menu-arrow')) {
            child.visible = visible;
        } else if (child.get_n_children() > 0) {
            let children = child.get_children();
            children.forEach(child => {
                this._updateVisibility(visible, child);
            });
        }
    }

    destroy() {
        Main.extensionManager.disconnect(this._extensionStateChangedID);
        this._settings.disconnect(this._settingsChangedId);
        this._updateVisibility(true, null);
    }
}
