/* extension.js
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

/* exported init */

const ExtensionUtils = imports.misc.extensionUtils;

const Main = imports.ui.main;

const Me = ExtensionUtils.getCurrentExtension();

const { ActivitiesButton } = Me.imports.activities;
const { ApplicationsMenuButton } = Me.imports.applications;
const { Dash } = Me.imports.dash;
const { DateMenuButton } = Me.imports.dateMenu;
const { FavoritesMenuButton } = Me.imports.favorites;
const { PlacesMenuButton } = Me.imports.places;
const { ShowDesktopButton } = Me.imports.showDesktop;
const { SystemMenuButton } = Me.imports.systemMenu;
const { TrashMenuButton } = Me.imports.recycleBin;

class Extension {
    constructor(uuid) {
        this._uuid = uuid;
        ExtensionUtils.initTranslations();
    }

    _addToStatusArea(role, indicator, position, box) {
        return Main.panel.addToStatusArea(role, indicator, position, box);
    }

    _enabled(settings) {
        this._activities = new ActivitiesButton(settings);
        this._dateMenu = new DateMenuButton(settings);
        this._systemMenu = new SystemMenuButton(this._uuid, settings);
        this._dash = new Dash(settings);
        this._applicationsMenu = this._addToStatusArea('applicationsMenu', new ApplicationsMenuButton(settings), 1, 'left');
        this._placesMenu = this._addToStatusArea('placesMenu', new PlacesMenuButton(settings), 2, 'left');
        this._favoritesMenu = this._addToStatusArea('favoritesMenu', new FavoritesMenuButton(settings), 3, 'left');
        this._showDesktop = this._addToStatusArea('showDesktop', new ShowDesktopButton(), 4, 'left');
        let pos = Main.sessionMode.panel.right.indexOf('quickSettings');
        this._trashMenu = this._addToStatusArea('trashMenu', new TrashMenuButton(), pos, 'right');
    }

    enable() {
        if (Main.layoutManager._startingUp) {
            this._startupComplete = Main.layoutManager.connect('startup-complete', () => {
                this._enabled(ExtensionUtils.getSettings());
                Main.layoutManager.disconnect(this._startupComplete);
            });
        } else {
            this._enabled(ExtensionUtils.getSettings());
        }
    }

    disable() {
        this._trashMenu.destroy();
        this._trashMenu = null;
        this._showDesktop.destroy();
        this._showDesktop = null;
        this._favoritesMenu.destroy();
        this._favoritesMenu = null;
        this._placesMenu.destroy();
        this._placesMenu = null;
        this._applicationsMenu.destroy();
        this._applicationsMenu = null;
        this._dash.destroy();
        this._dash = null;
        this._systemMenu.destroy();
        this._systemMenu = null;
        this._dateMenu.destroy();
        this._dateMenu = null;
        this._activities.destroy();
        this._activities = null;
    }
}

function init(meta) {
    return new Extension(meta.uuid);
}
