/* dash.js
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

/* exported Dash */

const Main = imports.ui.main;

const KEY_SHOW_DASH = 'show-dash';
const KEY_SHOW_DASH_APPLICATIONS = 'show-dash-applications';

var Dash = class {
    constructor(settings) {
        this._settings = settings;
        this._settingsChangedId = [
            this._settings.connect('changed::%s'.format(KEY_SHOW_DASH), this._onChangedShowDash.bind(this)),
            this._settings.connect('changed::%s'.format(KEY_SHOW_DASH_APPLICATIONS), this._onChangedShowDashApplications.bind(this)),
        ];
        this._notifyMappedId = Main.overview._overview.dash._box.connect('notify::mapped', this._onChangedShowDashApplications.bind(this));
        this._onChangedShowDash();
        this._onChangedShowDashApplications();
    }

    _onChangedShowDash() {
        let showDash = this._settings.get_boolean(KEY_SHOW_DASH);
        this._setVisibility(showDash);
    }

    _onChangedShowDashApplications() {
        let showDashApplications = this._settings.get_boolean(KEY_SHOW_DASH_APPLICATIONS);
        this._setVisibilityApplications(showDashApplications);
    }

    _setVisibility(visible) {
        Main.overview._overview.dash.visible = visible;
    }

    _setVisibilityApplications(visible) {
        Main.overview._overview.dash.showAppsButton.visible = visible;
    }

    destroy() {
        Main.overview._overview.dash._box.disconnect(this._notifyMappedId);
        this._settingsChangedId.forEach(id => {
            this._settings.disconnect(id);
        });
        this._setVisibilityApplications(true);
        this._setVisibility(true);
    }
};
